// $Id: CXMLAttribute.cpp,v 1.4 2007/02/08 21:06:44 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CXMLAttribute.hpp"
using Exponent::IO::CXMLAttribute;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CXMLAttribute, CCountedObject);

//	===========================================================================
CXMLAttribute::CXMLAttribute(const CString &name, const CString &value) 
			 : m_name(name)
			 , m_value(value)
{
	EXPONENT_CLASS_CONSTRUCTION(CXMLAttribute);

	// REmove spaces from the name
	m_name.removeTrailingAndLeadingWhiteSpace();

	// Replace any spaces in the tag
	m_name.replaceCharWithChar(' ', '_');
}

//	===========================================================================
CXMLAttribute::CXMLAttribute(const CString &name, const bool value)
			 : m_name(name)
{
	EXPONENT_CLASS_CONSTRUCTION(CXMLAttribute);

	// Store the value
	m_value = (value) ? "True" : "False";

	// REmove spaces from the name
	m_name.removeTrailingAndLeadingWhiteSpace();

	// Replace any spaces in the tag
	m_name.replaceCharWithChar(' ', '_');
}

//	===========================================================================
CXMLAttribute::CXMLAttribute(const CString &name, const double value)
			 : m_name(name)
{
	EXPONENT_CLASS_CONSTRUCTION(CXMLAttribute);

	// Store the value
	m_value.setStringWithFormat("%f", value);

	// REmove spaces from the name
	m_name.removeTrailingAndLeadingWhiteSpace();

	// Replace any spaces in the tag
	m_name.replaceCharWithChar(' ', '_');
}

//	===========================================================================
CXMLAttribute::CXMLAttribute(const CString &name, const float value)
			 : m_name(name)
{
	EXPONENT_CLASS_CONSTRUCTION(CXMLAttribute);

	// Store the value
	m_value.setStringWithFormat("%f", value);

	// REmove spaces from the name
	m_name.removeTrailingAndLeadingWhiteSpace();

	// Replace any spaces in the tag
	m_name.replaceCharWithChar(' ', '_');
}

//	===========================================================================
CXMLAttribute::CXMLAttribute(const CString &name, const long value)
			 : m_name(name)
{
	EXPONENT_CLASS_CONSTRUCTION(CXMLAttribute);

	// Store the value
	m_value.setStringWithFormat("%li", value);

	// REmove spaces from the name
	m_name.removeTrailingAndLeadingWhiteSpace();

	// Replace any spaces in the tag
	m_name.replaceCharWithChar(' ', '_');
}

//	===========================================================================
CXMLAttribute::CXMLAttribute(const CString &name, const int value)
			 : m_name(name)
{
	EXPONENT_CLASS_CONSTRUCTION(CXMLAttribute);

	// Store the value
	m_value.setStringWithFormat("%d", value);

	// REmove spaces from the name
	m_name.removeTrailingAndLeadingWhiteSpace();

	// Replace any spaces in the tag
	m_name.replaceCharWithChar(' ', '_');
}

//	===========================================================================
CXMLAttribute::~CXMLAttribute()
{
	EXPONENT_CLASS_DESTRUCTION(CXMLAttribute);
}

//	===========================================================================
void CXMLAttribute::setName(const CString &name)
{
	// STore the name
	m_name = name;

	// REmove spaces from the name
	m_name.removeTrailingAndLeadingWhiteSpace();

	// Replace any spaces in the tag
	m_name.replaceCharWithChar(' ', '_');
}

//	===========================================================================
void CXMLAttribute::setValue(const CString &value)
{
	m_value = value;
}

//	===========================================================================
void CXMLAttribute::setValue(const bool value)
{
	this->setValue(CString((value) ? "True" : "False"));
}

//	===========================================================================
void CXMLAttribute::setValue(const double value)
{
	CString theString;
	theString.setStringWithFormat("%f", value);
	this->setValue(theString);
}

//	===========================================================================
void CXMLAttribute::setValue(const float value)
{
	this->setValue((double)value);
}

//	===========================================================================
void CXMLAttribute::setValue(const long value)
{
	CString theString;
	theString.setStringWithFormat("%li", value);
	this->setValue(theString);
}

//	===========================================================================
void CXMLAttribute::setValue(const int value)
{
	CString theString;
	theString.setStringWithFormat("%d", value);
	this->setValue(theString);
}

//	===========================================================================
const CString &CXMLAttribute::getName() const
{
	return m_name;
}

//	===========================================================================
const CString &CXMLAttribute::getValue() const
{
	return m_value;
}

//	===========================================================================
double CXMLAttribute::getValueAsDouble() const
{
	return CString::toDouble(m_value.getString());
}

//	===========================================================================
float CXMLAttribute::getValueAsFloat() const
{
	return CString::toFloat(m_value.getString());
}

//	===========================================================================
long CXMLAttribute::getValueAsLong() const
{
	return CString::toLong(m_value.getString());
}

//	===========================================================================
int CXMLAttribute::getValueAsInt() const
{
	return CString::toInt(m_value.getString());
}

//	===========================================================================
bool CXMLAttribute::getValueAsBool() const
{
	return (m_value == "True");
}